/*
 * Svix API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.1.1
 * Generated by: https://github.com/openapitools/openapi-generator.git
 * 
 * Manually modified to add `EmitDefaultValue = false` in all properties. Null fields are ignored for PATCH requests.
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using FileParameter = Svix.Client.FileParameter;
using OpenAPIDateConverter = Svix.Client.OpenAPIDateConverter;

namespace Svix.Model
{
    /// <summary>
    /// EventTypePatch
    /// </summary>
    [DataContract(Name = "EventTypePatch")]
    public partial class EventTypePatch : IEquatable<EventTypePatch>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="EventTypePatch" /> class.
        /// </summary>
        /// <param name="archived">archived.</param>
        /// <param name="description">description.</param>
        /// <param name="featureFlag">featureFlag.</param>
        /// <param name="schemas">schemas.</param>
        public EventTypePatch(bool archived = default(bool), string description = default(string), string featureFlag = default(string), Dictionary<string, Object> schemas = default(Dictionary<string, Object>))
        {
            this.Archived = archived;
            this.Description = description;
            this.FeatureFlag = featureFlag;
            this.Schemas = schemas;
        }

        /// <summary>
        /// Gets or Sets Archived
        /// </summary>
        [DataMember(Name = "archived", EmitDefaultValue = false)]
        public bool Archived { get; set; }

        /// <summary>
        /// Gets or Sets Description
        /// </summary>
        [DataMember(Name = "description", EmitDefaultValue = false)]
        public string Description { get; set; }

        /// <summary>
        /// Gets or Sets FeatureFlag
        /// </summary>
        [DataMember(Name = "featureFlag", EmitDefaultValue = false)]
        public string FeatureFlag { get; set; }

        /// <summary>
        /// Gets or Sets Schemas
        /// </summary>
        [DataMember(Name = "schemas", EmitDefaultValue = false)]
        public Dictionary<string, Object> Schemas { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class EventTypePatch {\n");
            sb.Append("  Archived: ").Append(Archived).Append("\n");
            sb.Append("  Description: ").Append(Description).Append("\n");
            sb.Append("  FeatureFlag: ").Append(FeatureFlag).Append("\n");
            sb.Append("  Schemas: ").Append(Schemas).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as EventTypePatch);
        }

        /// <summary>
        /// Returns true if EventTypePatch instances are equal
        /// </summary>
        /// <param name="input">Instance of EventTypePatch to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(EventTypePatch input)
        {
            if (input == null)
                return false;

            return
                (
                    this.Archived == input.Archived ||
                    this.Archived.Equals(input.Archived)
                ) &&
                (
                    this.Description == input.Description ||
                    (this.Description != null &&
                    this.Description.Equals(input.Description))
                ) &&
                (
                    this.FeatureFlag == input.FeatureFlag ||
                    (this.FeatureFlag != null &&
                    this.FeatureFlag.Equals(input.FeatureFlag))
                ) &&
                (
                    this.Schemas == input.Schemas ||
                    this.Schemas != null &&
                    input.Schemas != null &&
                    this.Schemas.SequenceEqual(input.Schemas)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                hashCode = hashCode * 59 + this.Archived.GetHashCode();
                if (this.Description != null)
                    hashCode = hashCode * 59 + this.Description.GetHashCode();
                if (this.FeatureFlag != null)
                    hashCode = hashCode * 59 + this.FeatureFlag.GetHashCode();
                if (this.Schemas != null)
                    hashCode = hashCode * 59 + this.Schemas.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            // FeatureFlag (string) maxLength
            if (this.FeatureFlag != null && this.FeatureFlag.Length > 256)
            {
                yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for FeatureFlag, length must be less than 256.", new[] { "FeatureFlag" });
            }

            // FeatureFlag (string) pattern
            Regex regexFeatureFlag = new Regex(@"^[a-zA-Z0-9\\-_.]+$", RegexOptions.CultureInvariant);
            if (false == regexFeatureFlag.Match(this.FeatureFlag).Success)
            {
                yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for FeatureFlag, must match a pattern of " + regexFeatureFlag, new[] { "FeatureFlag" });
            }

            yield break;
        }
    }

}
