INSERT INTO eventtype(
    created_at, updated_at, id, org_id, description, deleted, schemas, name, feature_flag)
    VALUES (CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, 'evtype_2POKhK6pz91yFxPrGh92s2g38js', 'org_00000000000SvixManagement00', 'Sent when an endpoint is created.', false, '{"1": {"type": "object", "title": "EndpointCreatedEvent", "examples": [{"data": {"appId": "app_1srOrx2ZWZBpBUvZwXKQmoEYga2", "appUid": "unique-app-identifier", "endpointId": "ep_1srOrx2ZWZBpBUvZwXKQmoEYga2", "endpointUid": "unique-endpoint-identifier"}, "type": "endpoint.created"}], "required": ["data"], "properties": {"data": {"$ref": "#/definitions/EndpointCreatedEventData"}, "type": {"enum": ["endpoint.created"], "type": "string", "title": "Type", "default": "endpoint.created"}}, "definitions": {"EndpointCreatedEventData": {"type": "object", "title": "EndpointCreatedEventData", "required": ["appId", "endpointId"], "properties": {"appId": {"type": "string", "title": "Appid", "example": "app_1srOrx2ZWZBpBUvZwXKQmoEYga2"}, "appUid": {"type": "string", "title": "Appuid", "example": "unique-app-identifier", "pattern": "^[a-zA-Z0-9\\-_.]+$", "nullable": true, "maxLength": 256, "minLength": 1, "description": "Optional unique identifier for the application"}, "endpointId": {"type": "string", "title": "Endpointid", "example": "ep_1srOrx2ZWZBpBUvZwXKQmoEYga2"}, "endpointUid": {"type": "string", "title": "Endpointuid", "example": "unique-endpoint-identifier", "pattern": "^[a-zA-Z0-9\\-_.]+$", "nullable": true, "maxLength": 256, "minLength": 1, "description": "Optional unique identifier for the endpoint"}}}}, "description": "Sent when an endpoint is created."}}', 'endpoint.created', NULL);

INSERT INTO eventtype(
    created_at, updated_at, id, org_id, description, deleted, schemas, name, feature_flag)
    VALUES (CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, 'evtype_2POKhK6QKJWGeDVSWXY2vJgDSQB', 'org_00000000000SvixManagement00', 'Sent when an endpoint is updated.', false, '{"1": {"type": "object", "title": "EndpointUpdatedEvent", "examples": [{"data": {"appId": "app_1srOrx2ZWZBpBUvZwXKQmoEYga2", "appUid": "unique-app-identifier", "endpointId": "ep_1srOrx2ZWZBpBUvZwXKQmoEYga2", "endpointUid": "unique-endpoint-identifier"}, "type": "endpoint.updated"}], "required": ["data"], "properties": {"data": {"$ref": "#/definitions/EndpointUpdatedEventData"}, "type": {"enum": ["endpoint.updated"], "type": "string", "title": "Type", "default": "endpoint.updated"}}, "definitions": {"EndpointUpdatedEventData": {"type": "object", "title": "EndpointUpdatedEventData", "required": ["appId", "endpointId"], "properties": {"appId": {"type": "string", "title": "Appid", "example": "app_1srOrx2ZWZBpBUvZwXKQmoEYga2"}, "appUid": {"type": "string", "title": "Appuid", "example": "unique-app-identifier", "pattern": "^[a-zA-Z0-9\\-_.]+$", "nullable": true, "maxLength": 256, "minLength": 1, "description": "Optional unique identifier for the application"}, "endpointId": {"type": "string", "title": "Endpointid", "example": "ep_1srOrx2ZWZBpBUvZwXKQmoEYga2"}, "endpointUid": {"type": "string", "title": "Endpointuid", "example": "unique-endpoint-identifier", "pattern": "^[a-zA-Z0-9\\-_.]+$", "nullable": true, "maxLength": 256, "minLength": 1, "description": "Optional unique identifier for the endpoint"}}}}, "description": "Sent when an endpoint is updated."}}', 'endpoint.updated', NULL);

INSERT INTO eventtype(
    created_at, updated_at, id, org_id, description, deleted, schemas, name, feature_flag)
    VALUES (CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, 'evtype_2POKhK6vcRRnl2tyeEOfcQ15C4x', 'org_00000000000SvixManagement00', 'Sent when an endpoint is deleted.', false, '{"1": {"type": "object", "title": "EndpointDeletedEvent", "examples": [{"data": {"appId": "app_1srOrx2ZWZBpBUvZwXKQmoEYga2", "appUid": "unique-app-identifier", "endpointId": "ep_1srOrx2ZWZBpBUvZwXKQmoEYga2", "endpointUid": "unique-endpoint-identifier"}, "type": "endpoint.deleted"}], "required": ["data"], "properties": {"data": {"$ref": "#/definitions/EndpointDeletedEventData"}, "type": {"enum": ["endpoint.deleted"], "type": "string", "title": "Type", "default": "endpoint.deleted"}}, "definitions": {"EndpointDeletedEventData": {"type": "object", "title": "EndpointDeletedEventData", "required": ["appId", "endpointId"], "properties": {"appId": {"type": "string", "title": "Appid", "example": "app_1srOrx2ZWZBpBUvZwXKQmoEYga2"}, "appUid": {"type": "string", "title": "Appuid", "example": "unique-app-identifier", "pattern": "^[a-zA-Z0-9\\-_.]+$", "nullable": true, "maxLength": 256, "minLength": 1, "description": "Optional unique identifier for the application"}, "endpointId": {"type": "string", "title": "Endpointid", "example": "ep_1srOrx2ZWZBpBUvZwXKQmoEYga2"}, "endpointUid": {"type": "string", "title": "Endpointuid", "example": "unique-endpoint-identifier", "pattern": "^[a-zA-Z0-9\\-_.]+$", "nullable": true, "maxLength": 256, "minLength": 1, "description": "Optional unique identifier for the endpoint"}}}}, "description": "Sent when an endpoint is deleted."}}', 'endpoint.deleted', NULL);

INSERT INTO eventtype(
    created_at, updated_at, id, org_id, description, deleted, schemas, name, feature_flag)
    VALUES (CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, 'evtype_2POKhK70XG6GQHcqTkeGvID3EvB', 'org_00000000000SvixManagement00', 'Sent when an endpoint has been automatically disabled after continuous failures.', false, '{"1": {"type": "object", "title": "EndpointDisabledEvent", "examples": [{"data": {"appId": "app_1srOrx2ZWZBpBUvZwXKQmoEYga2", "appUid": "unique-app-identifier", "failSince": "1970-01-01T00:00:00", "endpointId": "ep_1srOrx2ZWZBpBUvZwXKQmoEYga2", "endpointUid": "unique-endpoint-identifier"}, "type": "endpoint.disabled"}], "required": ["data"], "properties": {"data": {"$ref": "#/definitions/EndpointDisabledEventData"}, "type": {"enum": ["endpoint.disabled"], "type": "string", "title": "Type", "default": "endpoint.disabled"}}, "definitions": {"EndpointDisabledEventData": {"type": "object", "title": "EndpointDisabledEventData", "required": ["appId", "endpointId", "failSince"], "properties": {"appId": {"type": "string", "title": "Appid", "example": "app_1srOrx2ZWZBpBUvZwXKQmoEYga2"}, "appUid": {"type": "string", "title": "Appuid", "example": "unique-app-identifier", "pattern": "^[a-zA-Z0-9\\-_.]+$", "nullable": true, "maxLength": 256, "minLength": 1, "description": "Optional unique identifier for the application"}, "failSince": {"type": "string", "title": "Failsince", "format": "date-time"}, "endpointId": {"type": "string", "title": "Endpointid", "example": "ep_1srOrx2ZWZBpBUvZwXKQmoEYga2"}, "endpointUid": {"type": "string", "title": "Endpointuid", "example": "unique-endpoint-identifier", "pattern": "^[a-zA-Z0-9\\-_.]+$", "nullable": true, "maxLength": 256, "minLength": 1, "description": "Optional unique identifier for the endpoint"}}}}, "description": "Sent when an endpoint has been automatically disabled after continuous failures."}}', 'endpoint.disabled', NULL);

INSERT INTO eventtype(
    created_at, updated_at, id, org_id, description, deleted, schemas, name, feature_flag)
    VALUES (CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, 'evtype_2POKhK6MvCdGn7rQmnj8yDYBuGJ', 'org_00000000000SvixManagement00', 'Sent after a message has been failing for a few times.', false, '{"1": {"type": "object", "title": "MessageAttemptFailingEvent", "examples": [{"data": {"appId": "app_1srOrx2ZWZBpBUvZwXKQmoEYga2", "msgId": "msg_1srOrx2ZWZBpBUvZwXKQmoEYga2", "appUid": "unique-app-identifier", "endpointId": "ep_1srOrx2ZWZBpBUvZwXKQmoEYga2", "msgEventId": "unique-msg-identifier", "lastAttempt": {"id": "atmpt_1srOrx2ZWZBpBUvZwXKQmoEYga2", "timestamp": "1970-01-01T00:00:00", "responseStatusCode": 500}}, "type": "message.attempt.failing"}], "required": ["data"], "properties": {"data": {"$ref": "#/definitions/MessageAttemptFailingEventData"}, "type": {"enum": ["message.attempt.failing"], "type": "string", "title": "Type", "default": "message.attempt.failing"}}, "definitions": {"MessageAttemptFailedData": {"type": "object", "title": "MessageAttemptFailedData", "required": ["id", "responseStatusCode", "timestamp"], "properties": {"id": {"type": "string", "title": "Id", "example": "atmpt_1srOrx2ZWZBpBUvZwXKQmoEYga2"}, "timestamp": {"type": "string", "title": "Timestamp", "format": "date-time"}, "responseStatusCode": {"type": "integer", "title": "Responsestatuscode", "example": 500}}}, "MessageAttemptFailingEventData": {"type": "object", "title": "MessageAttemptFailingEventData", "required": ["appId", "msgId", "endpointId", "lastAttempt"], "properties": {"appId": {"type": "string", "title": "Appid", "example": "app_1srOrx2ZWZBpBUvZwXKQmoEYga2"}, "msgId": {"type": "string", "title": "Msgid", "example": "msg_1srOrx2ZWZBpBUvZwXKQmoEYga2"}, "appUid": {"type": "string", "title": "Appuid", "example": "unique-app-identifier", "pattern": "^[a-zA-Z0-9\\-_.]+$", "nullable": true, "maxLength": 256, "minLength": 1, "description": "Optional unique identifier for the application"}, "endpointId": {"type": "string", "title": "Endpointid", "example": "ep_1srOrx2ZWZBpBUvZwXKQmoEYga2"}, "msgEventId": {"type": "string", "title": "Msgeventid", "example": "evt_pNZKtWg8Azow", "pattern": "^[a-zA-Z0-9\\-_.]+$", "nullable": true, "maxLength": 256, "minLength": 1, "description": "Optional unique identifier for the message"}, "lastAttempt": {"$ref": "#/definitions/MessageAttemptFailedData"}}}}, "description": "Sent after a message has been failing for a few times.\nSent on the fourth failure. It complements `message.attempt.exhausted` which is sent after the last failure."}}', 'message.attempt.failing', NULL);

INSERT INTO eventtype(
    created_at, updated_at, id, org_id, description, deleted, schemas, name, feature_flag)
    VALUES (CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, 'evtype_2POKhK7H4djUarm92hUYHt2HDI9', 'org_00000000000SvixManagement00', 'Sent when a message delivery has failed (all of the retry attempts have been exhausted).', false, '{"1": {"type": "object", "title": "MessageAttemptExhaustedEvent", "examples": [{"data": {"appId": "app_1srOrx2ZWZBpBUvZwXKQmoEYga2", "msgId": "msg_1srOrx2ZWZBpBUvZwXKQmoEYga2", "appUid": "unique-app-identifier", "endpointId": "ep_1srOrx2ZWZBpBUvZwXKQmoEYga2", "msgEventId": "unique-msg-identifier", "lastAttempt": {"id": "atmpt_1srOrx2ZWZBpBUvZwXKQmoEYga2", "timestamp": "1970-01-01T00:00:00", "responseStatusCode": 500}}, "type": "message.attempt.exhausted"}], "required": ["data"], "properties": {"data": {"$ref": "#/definitions/MessageAttemptExhaustedEventData"}, "type": {"enum": ["message.attempt.exhausted"], "type": "string", "title": "Type", "default": "message.attempt.exhausted"}}, "definitions": {"MessageAttemptFailedData": {"type": "object", "title": "MessageAttemptFailedData", "required": ["id", "responseStatusCode", "timestamp"], "properties": {"id": {"type": "string", "title": "Id", "example": "atmpt_1srOrx2ZWZBpBUvZwXKQmoEYga2"}, "timestamp": {"type": "string", "title": "Timestamp", "format": "date-time"}, "responseStatusCode": {"type": "integer", "title": "Responsestatuscode", "example": 500}}}, "MessageAttemptExhaustedEventData": {"type": "object", "title": "MessageAttemptExhaustedEventData", "required": ["appId", "msgId", "endpointId", "lastAttempt"], "properties": {"appId": {"type": "string", "title": "Appid", "example": "app_1srOrx2ZWZBpBUvZwXKQmoEYga2"}, "msgId": {"type": "string", "title": "Msgid", "example": "msg_1srOrx2ZWZBpBUvZwXKQmoEYga2"}, "appUid": {"type": "string", "title": "Appuid", "example": "unique-app-identifier", "pattern": "^[a-zA-Z0-9\\-_.]+$", "nullable": true, "maxLength": 256, "minLength": 1, "description": "Optional unique identifier for the application"}, "endpointId": {"type": "string", "title": "Endpointid", "example": "ep_1srOrx2ZWZBpBUvZwXKQmoEYga2"}, "msgEventId": {"type": "string", "title": "Msgeventid", "example": "evt_pNZKtWg8Azow", "pattern": "^[a-zA-Z0-9\\-_.]+$", "nullable": true, "maxLength": 256, "minLength": 1, "description": "Optional unique identifier for the message"}, "lastAttempt": {"$ref": "#/definitions/MessageAttemptFailedData"}}}}, "description": "Sent when a message delivery has failed (all of the retry attempts have been exhausted)."}}', 'message.attempt.exhausted', NULL);
